<?php

/**
 * Plugin Name:       Auxin Fonts
 * Plugin URI:        http://averta.net/phlox/
 * Description:       Extra custom fonts for Phlox theme
 * Version:           1.0.0
 * Author:            averta
 * Author URI:        http://averta.net
 * Text Domain:       auxin-fonts
 * License URI:       LICENSE.txt
 * Domain Path:       /languages
 * Tested up to:      4.9.1
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die('No Naughty Business Please !');
}

// Abort loading if WordPress is upgrading
if ( defined( 'WP_INSTALLING' ) && WP_INSTALLING ) {
    return;
}



define( 'PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FONTS_DIR', PLUGIN_URL . 'fonts' );
define( 'FONT_FACE_FILE', 'font-face.css' );

function auxin_fonts_after_load() {

    require_once 'includes/auxin-fonts-general.php';

    if ( ! defined( 'THEME_ID' ) || 'phlox' != THEME_ID ) {
        require_once 'includes/auxin-fonts-standalone.php';
    }

}

add_action( 'after_setup_theme', 'auxin_fonts_after_load' );
